<?php
/**
 * magictoolbox product_listing module
 */

    $orig = dirname(__FILE__) . '/product_listing_original.php';
    if(!file_exists($orig)) {
        $orig = dirname(dirname($orig)) . '/product_listing.php';
    }
    require_once($orig);

    //load module
    require_once(DIR_FS_CATALOG . DIR_WS_MODULES . 'magictoolbox/magictoolbox_addons.php');

    $mod = & magictoolboxLoadModule('MagicThumb');

    if((!$mod->params->checkValue("use-effect-on-category-page", "No")
        // ensure that current page is category (also works with friendly URLS - SEF) or search page 
        && ($GLOBALS['category_depth'] == 'products' && intval($GLOBALS['current_category_id']) > 0 || 
        intval($_GET['manufacturers_id']) > 0) && (preg_match("/index\.php/is", $GLOBALS['_SERVER']['REQUEST_URI']) || 
        preg_match('/-[cm]-[0-9_]+\.html/is', $GLOBALS['_SERVER']['REQUEST_URI']))) 

        || ($_REQUEST['main_page'] == 'advanced_search_result' && !$mod->params->checkValue('use-effect-on-products-search-page', 'No'))
    ) {



        foreach($list_box_contents as $rowkey => $row) {
            if(preg_match('/productListing-(row)?heading/is', $row[0]['params'])) {
                // skip table header
                continue;
            }
            foreach($row as $key => $arr) {
                if(!is_int($key)) {
                    continue;
                }
                $text = $arr['text'];

                $img = preg_replace("/^.*?<img[^>]*src=\"(.*?)\".*$/is", "$1", $text);
                if($img == $text || preg_match('/buy.now/is', $img)) {
                    continue;
                }
                $imgOrig = $img;
                $img = str_replace(DIR_FS_CATALOG . DIR_WS_IMAGES, '', $img);
                $img = str_replace(DIR_WS_IMAGES, '', $img);
                $thumb = DIR_WS_CATALOG . magictoolboxGetThumb(DIR_WS_IMAGES . $img, $mod->params->getValue("thumb-size-category-page"), $mod->params->getValue('thumb-size-depends-on'), $mod->params->getValue('image-magick-path'));
                $aHref = preg_replace("/^.*?<a[^>]*href=\"(.*?)\".*$/is", "$1", $text);

                if($mod->params->checkValue('link-to-product-page', 'Yes')) {
                $link = $aHref;
                } else { 

                $link = '';
                }

                
                $title = preg_replace("/^.*?<img[^>]*title=\"(.*?)\".*$/is", "$1", $text);
                if($title == $text) $title = preg_replace("/^.*?<img[^>]*alt=\"(.*?)\".*$/is", "$1", $text);
                if($title == $text) $title = "";
                
                $img = DIR_WS_CATALOG . DIR_WS_IMAGES . $img;
                $text = $mod->template(compact('img', 'thumb', 'title', 'link'));
                


                $arr['text'] = preg_replace('/<a[^>]+><img[^>]+?src=\"' . preg_quote($imgOrig, '/') . '\"[^>]+><\/a>/is', $text, $arr['text']);

                $list_box_contents[$rowkey][$key] = $arr;

            }
        }
    }

?>
