<?php
//
// +----------------------------------------------------------------------+
// |zen-cart Open Source E-commerce                                       |
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 The zen-cart developers                           |
// |                                                                      |   
// | http://www.zen-cart.com/index.php                                    |   
// |                                                                      |   
// | Portions Copyright (c) 2003 osCommerce                               |
// +----------------------------------------------------------------------+
// | This source file is subject to version 2.0 of the GPL license,       |
// | that is bundled with this package in the file LICENSE, and is        |
// | available through the world-wide-web at the following url:           |
// | http://www.zen-cart.com/license/2_0.txt.                             |
// | If you did not receive a copy of the zen-cart license and are unable |
// | to obtain it through the world-wide-web, please send a note to       |
// | license@zen-cart.com so we can mail you a copy immediately.          |
// +----------------------------------------------------------------------+
/*
  $Id: _yuupack.php,v 1.1 2004/02/27 05:58:22 hisasue Exp $

  Yuupack Shipping Calculator.
  Calculate shipping costs.

  2002/03/29 written by TAMURA Toshihiko (tamura@bitscope.co.jp)
  2003/04/10 modified for ms1
  2004/02/27 modified for ZenCart by HISASUE Takahiro ( hisa@flatz.jp )
 */
/*
    $rate = new _Yuupack('yuupack','通常便');
    $rate->SetOrigin('北海道', 'JP');   // 北海道から
    $rate->SetDest('東京都', 'JP');     // 東京都まで
    $rate->SetWeight(10);           // kg
    $quote = $rate->GetQuote();
    print $quote['type'] . "<br>";
    print $quote['cost'] . "\n";
*/
class _Yuupack {
    var $quote;
    var $OriginZone;
    var $OriginCountryCode = 'JP';
    var $DestZone;
    var $DestCountryCode = 'JP';
    var $Weight = 0;
    var $Length = 0;
    var $Width  = 0;
    var $Height = 0;

    // コンストラクタ
    // $id:   module id
    // $titl: module name
    // $zone: 都道府県コード '01'～'47'
    // $country: country code
    function _Yuupack($id, $title, $zone = NULL, $country = NULL) {
        $this->quote = array('id' => $id, 'title' => $title);
        if($zone) {
            $this->SetOrigin($zone, $country);
        }
    }
    // 発送元をセットする
    // $zone: 都道府県コード '01'～'47'
    // $country: country code
    function SetOrigin($zone, $country = NULL) {
        $this->OriginZone = $zone;
        if($country) {
            $this->OriginCountryCode = $country;
        }
    }
    function SetDest($zone, $country = NULL) {
        $this->DestZone = $zone;
        if($country) {
            $this->DestCountryCode = $country;
        }
    }
    function SetWeight($weight) {
        //$this->Weight = $weight;
        $this->Weight = $weight;
    }
    function SetSize($length = NULL, $width = NULL, $height = NULL) {
        if($length) {
            $this->Length = $length;
        }
        if($width) {
            $this->Width = $width;
        }
        if($height) {
            $this->Height = $height;
        }
    }
    // サイズ区分(0～4)を返す
    // 規格外の場合は9を返す
    //
    // 区分  サイズ名  ３辺計   重量
    // ----------------------------------
    // 0     60サイズ  60cmまで  2kgまで
    // 1     80サイズ  80cmまで  5kgまで
    // 2    100サイズ 100cmまで 10kgまで
    // 3    140サイズ 140cmまで 20kgまで
    // 4    160サイズ 160cmまで 30kgまで
    // 9    規格外    
    function GetSizeClass() {
        $a_classes = array(
            array(0,  60, 30),  // 区分,３辺計,重量
            array(1,  80, 30),
            array(2, 100, 30),
            array(3, 120, 30),
            array(4, 140, 30),
            array(5, 160, 30),
            array(6, 170, 30)
        );

        $n_totallength = $this->Length + $this->Width + $this->Height;

        while (list($n_index, $a_limit) = each($a_classes)) {
            if ($n_totallength <= $a_limit[1] && $this->Weight <= $a_limit[2]) {
                return $a_limit[0];
            }
        }
        return -1;  // 規格外
    }
    // 送付元と送付先からキーを作成する
    //
    function GetDistKey() {
        $s_key = '';
        $s_z1 = $this->GetLZone($this->OriginZone);
        $s_z2 = $this->GetLZone($this->DestZone);
        if ( $s_z1 && $s_z2 ) {
            // 地帯コードをアルファベット順に連結する
            if ( ord($s_z1) < ord($s_z2) ) {
                $s_key = $s_z1 . $s_z2;
            } else {
                $s_key = $s_z2 . $s_z1;
            }
        }
        return $s_key;
    }
    // 都道府県コードから地帯コードを取得する
    // $zone: 都道府県コード
    function GetLZone($zone) {
        // 都道府県コードを地帯コード('A'～'M')に変換する
        //  北海道:'A' = 北海道
        //  東北  :'B' = 青森県,岩手県,秋田県,宮城県,山形県,福島県
        //  関東  :'C' = 茨城県,栃木県,群馬県,埼玉県,千葉県,
        //  東京  :'D' = 東京都
        //  東京  :'E' = 神奈川県,山梨県
        //  信越  :'F' = 新潟県,長野県
        //  北陸  :'G' = 富山県,石川県,福井県
        //  東海  :'H' = 岐阜県,静岡県,愛知県,三重県
        //  関西  :'I' = 滋賀県,京都府,大阪府,兵庫県,奈良県,和歌山県
        //  中国  :'J' = 鳥取県,島根県,岡山県,広島県,山口県
        //  四国  :'K' = 徳島県,香川県,愛媛県,高知県
        //  九州  :'L' = 福岡県,佐賀県,長崎県,大分県,熊本県,宮崎県,鹿児島県
        //  沖縄  :'M' = 沖縄県 	
        $a_zonemap = array(
        '北海道'=>'A',  
        '青森県'=>'B',  
        '岩手県'=>'B',  
        '宮城県'=>'B',  
        '秋田県'=>'B',  
        '山形県'=>'B',  
        '福島県'=>'B',  
        '茨城県'=>'C',  
        '栃木県'=>'C',  
        '群馬県'=>'C',  
        '埼玉県'=>'C',  
        '千葉県'=>'C',  
        '東京都'=>'D',  
        '神奈川県'=>'E',  
        '山梨県'=>'E',  
        '新潟県'=>'F',  
        '長野県'=>'F',  
        '富山県'=>'G',  
        '石川県'=>'G',  
        '福井県'=>'G',  
        '岐阜県'=>'H',  
        '静岡県'=>'H',  
        '愛知県'=>'H',  
        '三重県'=>'H',  
        '滋賀県'=>'I',  
        '京都府'=>'I',  
        '大阪府'=>'I',  
        '兵庫県'=>'I',  
        '奈良県'=>'I',  
        '和歌山県'=>'I',  
        '鳥取県'=>'J',  
        '島根県'=>'J',  
        '岡山県'=>'J',  
        '広島県'=>'J',  
        '山口県'=>'J',  
        '徳島県'=>'K',  
        '香川県'=>'K',  
        '愛媛県'=>'K',  
        '高知県'=>'K',  
        '福岡県'=>'L',  
        '佐賀県'=>'L',  
        '長崎県'=>'L',  
        '熊本県'=>'L',  
        '大分県'=>'L',  
        '宮崎県'=>'L',  
        '鹿児島県'=>'L',  
        '沖縄県'=>'M'   
        );
        return $a_zonemap[$zone];
    }

    function GetQuote() {
        // 距離別の価格ランク: ランクコード => 価格(60,80,100,120,140,160,170)        
          $a_pricerank = array(
        'N01'=>array( 600, 800,1000,1200,1400,1600,1700), // 通常便(01) 市内
        'N02'=>array( 800,1000,1200,1400,1600,1800,2000), // 通常便(02)   ↑
        'N03'=>array( 700, 900,1100,1300,1500,1700,1900), // 通常便(03)
        'N04'=>array(1000,1200,1400,1600,1800,2000,2200), // 通常便(04)
        'N05'=>array(1000,1200,1400,1600,1800,2000,2200), // 通常便(05)
        'N06'=>array(1000,1200,1400,1600,1800,2000,2200), // 通常便(06)
        'N07'=>array(1100,1300,1500,1700,1900,2100,2300), // 通常便(07)
        'N08'=>array(1100,1300,1500,1700,1900,2100,2300), // 通常便(08)
        'N09'=>array(1200,1400,1600,1800,2000,2200,2400), // 通常便(09)
        'N10'=>array(1300,1500,1700,1900,2100,2300,2500), // 通常便(10) 遠距離
        'N11'=>array(1300,1500,1700,1900,2100,2300,2500), // 通常便(11) 遠距離
        'N12'=>array(1300,1500,1700,1900,2100,2300,2500), // 通常便(12) 遠距離
        'N13'=>array(1300,1500,1700,1900,2100,2300,2500), // 通常便(13) 遠距離
          );
        //差出地 愛知県
        $a_dist_to_rank = array(
        'HA'=>'N07',
        'HB'=>'N02',
        'HC'=>'N03',
        'HD'=>'N03',
        'HE'=>'N03',
        'HF'=>'N03',
        'HG'=>'N03',
        'HH'=>'N01',
        'HI'=>'N03',
        'HJ'=>'N02',
        'HK'=>'N02',
        'HL'=>'N04',
        'HM'=>'N09',
		);
        $s_key = $this->GetDistKey();
        if ( $s_key ) {
            $s_rank = $a_dist_to_rank[$s_key];
            if ( $s_rank ) {
                $n_sizeclass = $this->GetSizeClass();
                if ($n_sizeclass < 0) {
                    $this->quote['error'] = MODULE_SHIPPING_YUUPACK_TEXT_OVERSIZE;
                } else {
                    $this->quote['cost'] = $a_pricerank[$s_rank][$n_sizeclass];
                }
              //$this->quote['DEBUG'] = ' zone=' . $this->OriginZone . '=>' . $this->DestZone   //DEBUG
              //              . ' cost=' . $a_pricerank[$s_rank][$n_sizeclass];           //DEBUG
            } else {
                $this->quote['error'] = MODULE_SHIPPING_YUUPACK_TEXT_OUT_OF_AREA . '(' . $s_key .')';
            }
        } else {
            $this->quote['error'] = MODULE_SHIPPING_YUUPACK_TEXT_ILLEGAL_ZONE . '(' . $this->OriginZone . '=>' . $this->DestZone . ')';
        }
        return $this->quote;
    }
}
?>