<?php
    
if(!in_array('MagicThumbModuleCoreClass', get_declared_classes())) {

    require_once(dirname(__FILE__) . '/magictoolbox.params.class.php');

	class MagicThumbModuleCoreClass {
		var $params;
        var $id;
        var $type = 'standard';

		function MagicThumbModuleCoreClass() {
			$this->params = new MagicToolboxParams();
			$this->_paramDefaults();
		}
		
		function headers($jsPath = '', $cssPath = null, $notCheck = false) {
			if($cssPath == null) {
                $cssPath = $jsPath;
            }
			$headers = array();
            $headers[] = '<!-- Magic Thumb Zen Cart module version 3.0.2.1 -->';         
			$headers[] = '<link type="text/css" href="' . $cssPath . '/magicthumb.css" rel="stylesheet" media="screen" />';
			$headers[] = '<script type="text/javascript" src="' . $jsPath . '/magicthumb.js"></script>';

            if($this->params->checkValue('restore-speed', '-1')) {
                $this->params->set('restore-speed', $this->params->getValue('expand-speed'));
            }

            $conf = Array(
                "'expand-speed': " . $this->params->getValue("expand-speed"),
                "'restore-speed': " . $this->params->getValue("restore-speed"),
                "'expand-effect': '" . $this->params->getValue("expand-effect") . "'",
                "'restore-effect': '" . $this->params->getValue("restore-effect") . "'",
                "'expand-trigger': '" . $this->params->getValue("expand-trigger") . "'",
                "'restore-trigger': '" . $this->params->getValue("restore-trigger") . "'",
                "'expand-trigger-delay': " . $this->params->getValue("expand-trigger-delay"),
                "'expand-align': '" . $this->params->getValue("expand-align") . "'",
                "'expand-position': '" . $this->params->getValue("expand-position") . "'",
                "'image-size': '" . $this->params->getValue("image-size") . "'",
                //"'keep-thumbnail': " . $this->params->getValue("keep-thumbnail"),
                //"'click-to-initialize': " . $this->params->getValue("click-to-initialize"),
                "'background-color': '" . $this->params->getValue("background-color") . "'",
                "'background-opacity': " . $this->params->getValue("background-opacity"),
                "'background-speed': " . $this->params->getValue("background-speed"),
                //!!!!!!//"'caption-source': '" . $this->params->getValue("caption-source") . "'",
                "'caption-speed': " . $this->params->getValue("caption-speed"),
                "'caption-position': '" . $this->params->getValue("caption-position") . "'",
                "'caption-height': " . $this->params->getValue("caption-height"),
                "'caption-width': " . $this->params->getValue("caption-width"),
                "'buttons': '" . $this->params->getValue("buttons") . "'",
                "'buttons-position': '" . $this->params->getValue("buttons-position") . "'",
                "'buttons-display': '" . $this->params->getValue("buttons-display") . "'",
                //"'show-loading': " . $this->params->getValue("show-loading"),
                "'loading-msg': '" . $this->params->getValue("loading-msg") . "'",
                "'loading-opacity': " . $this->params->getValue("loading-opacity"),
                "'swap-image': '" . $this->params->getValue("swap-image") . "'",
                "'swap-image-delay': " . $this->params->getValue("swap-image-delay"),
                "'slideshow-effect': '" . $this->params->getValue("slideshow-effect") . "'",
                "'slideshow-speed': " . $this->params->getValue("slideshow-speed"),
                //"'slideshow-loop': " . $this->params->getValue("slideshow-loop"),
                //"'link': '" . $this->params->getValue("link") . "'",
                //"'link-target': '" . $this->params->getValue("link-target") . "'",
                //"'thumb-id': '" . $this->params->getValue("thumb-id") . "'",
                //"'group': '" . $this->params->getValue("group") . "'",
                //"'keyboard': " . $this->params->getValue("keyboard"),
                //"'keyboard-ctrl': " . $this->params->getValue("keyboard-ctrl"),
                "'z-index': " . $this->params->getValue("z-index"),
            );
            
            if($notCheck) {
                $conf = array_merge($conf, array(
                    "'keep-thumbnail': " . $this->params->getValue("keep-thumbnail"),
                    "'click-to-initialize': " . $this->params->getValue("click-to-initialize"),
                    "'show-loading': " . $this->params->getValue("show-loading"),
                    "'slideshow-loop': " . $this->params->getValue("slideshow-loop"),
                    "'keyboard': " . $this->params->getValue("keyboard"),
                    "'keyboard-ctrl': " . $this->params->getValue("keyboard-ctrl"),
                ));
            } else {
                $conf = array_merge($conf, array(
                    "'keep-thumbnail': " . ($this->params->getValue('keep-thumbnail')=='Yes'?'true':'false'),
                    "'click-to-initialize': " . ($this->params->getValue('click-to-initialize')=='Yes'?'true':'false'),
                    "'show-loading': " . ($this->params->getValue('show-loading')=='Yes'?'true':'false'),
                    "'slideshow-loop': " . ($this->params->getValue('slideshow-loop')=='Yes'?'true':'false'),
                    "'keyboard': " . ($this->params->getValue('keyboard')=='Yes'?'true':'false'),
                    "'keyboard-ctrl': " . ($this->params->getValue('keyboard-ctrl')=='Yes'?'true':'false'),
                ));
            }
            
    		$headers[] = "<script type=\"text/javascript\">\n\tMagicThumb.options = {\n\t\t".implode(",\n\t\t",$conf)."\n\t}\n</script>\n";
            
			return implode("\r\n", $headers);
		}
        
        function template($params) {
            extract($params);
            $rel = array();
            
            if(!isset($img) || empty($img)) return false;
            if(!isset($thumb) || empty($thumb)) $thumb = $img;
            if(!isset($id) || empty($id)) $id = md5($img);
            
            $this->id = $id;
            
            if(!isset($alt) || empty($alt)) $alt = '';
            if(!isset($title)) $title = '';
            if(empty($alt) && !empty($title)) $alt = $title;
            if(!isset($description)) $description = '';
            
            if($this->params->checkValue('show-caption', 'Yes')) {
                if($this->params->checkValue('caption-source', array('Title','Both')) && !empty($title)) {
                    //$title = "<b>{$title}</b><br />";
                } else {
                    $title = '';
                }
                if($this->params->checkValue('caption-source', array('Both')) && !empty($description) && !empty($title)) {
                    $title = "<b>{$title}</b><br />";
                }
                if($this->params->checkValue('caption-source', array('Description','Both')) && !empty($description)) $title .= $description;
            } else $title = '';
            $title = trim(preg_replace("/\s+/is", " ", $title));
            if(!empty($title)) {
                $title = preg_replace("/<(\/?)a([^>]*)>/is", "[$1a$2]", $title);
                $title = "<span>{$title}</span>";
            }
            
            if(!isset($width) || empty($width)) $width = "";
            else $width = " width=\"{$width}\"";
            if(!isset($height) || empty($height)) $height = "";
            else $height = " height=\"{$height}\"";

            if(isset($link) && !empty($link)) {
                $rel[] = 'link: ' . ($link);
            }

            if($this->params->checkValue('show-message', 'Yes')) {
                $message = $this->params->getValue('message');
            } else $message = '';
            //if(!empty($message)) $message = "<div style=\"text-align:center;\">{$message}</div>";
            if(!empty($message)) $message = '<br />' . $message;

            if(!empty($rel)) {
                $rel = ' rel="' . implode('; ', $rel) . '"';
            } else {
                $rel = '';
            }
            return "<a class=\"MagicThumb\" id=\"MagicThumbImage{$id}\" href=\"{$img}\"{$rel}><img{$width}{$height} src=\"{$thumb}\" alt=\"{$alt}\" />{$title}</a>{$message}";
        }
		
		function subTemplate($params) {
        
            if($this->params->checkValue('use-selectors', 'No')) {
                unset($params['id']);
                $this->params->set('show-message', 'No');
                return $this->template($params);
            } else {
                extract($params);
            
                if(!isset($img) || empty($img)) return false;
                if(!isset($medium) || empty($medium)) $medium = $img;
                if(!isset($thumb) || empty($thumb)) $thumb = $img;
                if(!isset($id) || empty($id)) $id = $this->id;
                
                if(!isset($alt) || empty($alt)) $alt = '';
                if(!isset($title)) $title = '';
                if(empty($alt) && !empty($title)) $alt = $title;
                if(!isset($description)) $description = '';
                
                if($this->params->checkValue('show-caption', 'Yes')) {
                    if($this->params->checkValue('caption-source', array('Title','Both')) && !empty($title)) {
                        //$title = "<b>{$title}</b><br />";
                    } else {
                        $title = '';
                    }
                    if($this->params->checkValue('caption-source', array('Both')) && !empty($description) && !empty($title)) {
                        $title = "<b>{$title}</b><br />";
                    }
                    if($this->params->checkValue('caption-source', array('Description','Both')) && !empty($description)) $title .= $description;
                } else $title = '';
                $title = trim(preg_replace("/\s+/is", " ", $title));
                if(!empty($title)) {
                    $title = preg_replace("/<(\/?)a([^>]*)>/is", "[$1a$2]", $title);
                    $title = addslashes($title);
                    $title = " title=\"{$title}\"";
                }
                
                if(!isset($width) || empty($width)) $width = "";
                else $width = " width=\"{$width}\"";
                if(!isset($height) || empty($height)) $height = "";
                else $height = " height=\"{$height}\"";
    
                return "<a{$title} href=\"{$img}\" rel=\"thumb-id: MagicThumbImage{$id}\" rev=\"$medium\"><img{$width}{$height} src=\"{$thumb}\" alt=\"{$alt}\" /></a>";
            }
		}
		
		function getRel($notCheck = false) {
			return '';
		}
		
		function addonsTemplate() {
			return '';
		}
		
		function _paramDefaults() {
			$params = array(
    
        "expand-speed" => array(
            "id" => "expand-speed",
            "default" => "500",
            "label" => "Expand duration (milliseconds: 0-10000)",
            "type" => "num",
            
        ),
    
        "restore-speed" => array(
            "id" => "restore-speed",
            "default" => "-1",
            "label" => "Restore duration (milliseconds: 0-10000, -1: use expand-speed value)",
            "type" => "num",
            
        ),
    
        "expand-effect" => array(
            "id" => "expand-effect",
            "default" => "linear",
            "label" => "Effect while expanding image",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("linear","cubic","back","elastic","bounce",),
            
        ),
    
        "restore-effect" => array(
            "id" => "restore-effect",
            "default" => "linear",
            "label" => "Effect while restoring image",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("linear","cubic","back","elastic","bounce",),
            
        ),
    
        "expand-trigger" => array(
            "id" => "expand-trigger",
            "default" => "click",
            "label" => "Trigger for the enlarge effect",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("click","mouseover",),
            
        ),
    
        "expand-trigger-delay" => array(
            "id" => "expand-trigger-delay",
            "default" => "500",
            "label" => "Delay before mouseover triggers expand effect (milliseconds: 0 or larger)",
            "type" => "num",
            
        ),
    
        "restore-trigger" => array(
            "id" => "restore-trigger",
            "default" => "auto",
            "label" => "Trigger to restore image to its small state",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("auto","click","mouseout",),
            
        ),
    
        "expand-align" => array(
            "id" => "expand-align",
            "default" => "screen",
            "label" => "Align expanded image relative to screen or thumbnail",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("screen","image",),
            
        ),
    
        "expand-position" => array(
            "id" => "expand-position",
            "default" => "center",
            "label" => "Precise position of enlarged image (px)",
            "type" => "text",
            
            "description" => "The value can be 'center' or coordinates. E.g. 'top:0, left:0' or 'bottom:100, left:100'",
            
        ),
    
        "image-size" => array(
            "id" => "image-size",
            "default" => "fit-screen",
            "label" => "Size of the enlarged image",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("original","fit-screen",),
            
        ),
    
        "keep-thumbnail" => array(
            "id" => "keep-thumbnail",
            "default" => "Yes",
            "label" => "Show/hide thumbnail when image enlarged",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "click-to-initialize" => array(
            "id" => "click-to-initialize",
            "default" => "No",
            "label" => "Click to download large image",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "background-color" => array(
            "id" => "background-color",
            "default" => "#000000",
            "label" => "Fade background color (RGB)",
            "type" => "text",
            
        ),
    
        "background-opacity" => array(
            "id" => "background-opacity",
            "default" => "0",
            "label" => "Opacity of the background effect (0-100)",
            "type" => "num",
            
        ),
    
        "background-speed" => array(
            "id" => "background-speed",
            "default" => "200",
            "label" => "Speed of the fade effect (milliseconds: 0 or larger)",
            "type" => "num",
            
        ),
    
        "show-caption" => array(
            "id" => "show-caption",
            "default" => "Yes",
            "label" => "Show caption",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "caption-source" => array(
            "id" => "caption-source",
            "default" => "Description",
            "label" => "Caption source",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("Title","Description","Both",),
            
        ),
    
        "caption-speed" => array(
            "id" => "caption-speed",
            "default" => "250",
            "label" => "Speed of the caption slide effect (milliseconds: 0 or larger)",
            "type" => "num",
            
        ),
    
        "caption-position" => array(
            "id" => "caption-position",
            "default" => "bottom",
            "label" => "Where to position the caption",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("bottom","right","left",),
            
        ),
    
        "caption-height" => array(
            "id" => "caption-height",
            "default" => "300",
            "label" => "Max height of bottom caption (milliseconds: 0 or larger)",
            "type" => "num",
            
        ),
    
        "caption-width" => array(
            "id" => "caption-width",
            "default" => "300",
            "label" => "Max width of bottom caption (milliseconds: 0 or larger)",
            "type" => "num",
            
        ),
    
        "buttons" => array(
            "id" => "buttons",
            "default" => "show",
            "label" => "Whether to show navigation buttons",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("show","hide","autohide",),
            
        ),
    
        "buttons-position" => array(
            "id" => "buttons-position",
            "default" => "auto",
            "label" => "Location of navigation buttons",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("auto","top left","top right","bottom left","bottom right",),
            
        ),
    
        "buttons-display" => array(
            "id" => "buttons-display",
            "default" => "previous, next, close",
            "label" => "Display button",
            "type" => "text",
            
            "description" => "Show all three buttons or just one or two. E.g. 'previous, next' or 'close, next'",
            
        ),
    
        "show-loading" => array(
            "id" => "show-loading",
            "default" => "Yes",
            "label" => "Show or not loading box",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "loading-msg" => array(
            "id" => "loading-msg",
            "default" => "Loading",
            "label" => "Text of the loading message",
            "type" => "text",
            
        ),
    
        "loading-opacity" => array(
            "id" => "loading-opacity",
            "default" => "75",
            "label" => "Opacity of the loading box (0 to 100)",
            "type" => "num",
            
        ),
    
        "swap-image" => array(
            "id" => "swap-image",
            "default" => "click",
            "label" => "Method to switch between multiple images",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("click","mouseover",),
            
        ),
    
        "swap-image-delay" => array(
            "id" => "swap-image-delay",
            "default" => "100",
            "label" => "Delay before switching thumbnails (milliseconds: 0 or larger)",
            "type" => "num",
            
        ),
    
        "slideshow-effect" => array(
            "id" => "slideshow-effect",
            "default" => "dissolve",
            "label" => "Visual effect for switching images",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("dissolve","fade","expand",),
            
        ),
    
        "slideshow-speed" => array(
            "id" => "slideshow-speed",
            "default" => "800",
            "label" => "Speed of slideshow effect (milliseconds: 0 or larger)",
            "type" => "num",
            
        ),
    
        "slideshow-loop" => array(
            "id" => "slideshow-loop",
            "default" => "Yes",
            "label" => "Restart slideshow after last image",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "keyboard" => array(
            "id" => "keyboard",
            "default" => "Yes",
            "label" => "Ability to use keyboard shortcuts",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "keyboard-ctrl" => array(
            "id" => "keyboard-ctrl",
            "default" => "No",
            "label" => "Require Ctrl key to permit shortcuts",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "z-index" => array(
            "id" => "z-index",
            "default" => "10001",
            "label" => "The z-index for the enlarged image",
            "type" => "num",
            
        ),
    
        "show-message" => array(
            "id" => "show-message",
            "default" => "Yes",
            "label" => "Show message under image?",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "message" => array(
            "id" => "message",
            "default" => "Click to enlarge",
            "label" => "Message under images",
            "type" => "text",
            
        ),
    
        "use-selectors" => array(
            "id" => "use-selectors",
            "default" => "Yes",
            "label" => "Use or no additional images as selectors",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "image-magick-path" => array(
            "id" => "image-magick-path",
            "default" => "/usr/bin",
            "label" => "Image magick binaries path",
            "type" => "text",
            
        ),
    
        "use-effect-on-product-page" => array(
            "id" => "use-effect-on-product-page",
            "default" => "Yes",
            "label" => "Use effect for product page",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "use-effect-on-category-page" => array(
            "id" => "use-effect-on-category-page",
            "default" => "No",
            "label" => "Use effect for categories",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "use-effect-on-whats-new-block" => array(
            "id" => "use-effect-on-whats-new-block",
            "default" => "No",
            "label" => "Use effect for 'Whats new' block",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "use-effect-on-products-new-page" => array(
            "id" => "use-effect-on-products-new-page",
            "default" => "No",
            "label" => "Use effect on new products page",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "use-effect-on-products-all-page" => array(
            "id" => "use-effect-on-products-all-page",
            "default" => "No",
            "label" => "Use effect on All products page",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "use-effect-on-products-search-page" => array(
            "id" => "use-effect-on-products-search-page",
            "default" => "No",
            "label" => "Use effect on products search results page",
            "type" => "array",
            
            "subType" => "radio",
            "values" => array("Yes","No",),
            
        ),
    
        "thumb-size-depends-on" => array(
            "id" => "thumb-size-depends-on",
            "default" => "both",
            "label" => "Size of thumbnail depends on",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("width","height","both",),
            
        ),
    
        "thumb-size" => array(
            "id" => "thumb-size",
            "default" => "250",
            "label" => "Size of thumbnail (in pixels)",
            "type" => "num",
            
        ),
    
        "selector-size" => array(
            "id" => "selector-size",
            "default" => "150",
            "label" => "Size of addittional thumbnails (in pixels)",
            "type" => "num",
            
        ),
    
        "thumb-size-category-page" => array(
            "id" => "thumb-size-category-page",
            "default" => "150",
            "label" => "Size of thumbnail on category pages (in pixels)",
            "type" => "num",
            
        ),
    
        "thumb-size-whats-new-block" => array(
            "id" => "thumb-size-whats-new-block",
            "default" => "50",
            "label" => "Size of thumbnail on 'Whats new' block (in pixels)",
            "type" => "num",
            
        ),
    
        "link-to-product-page" => array(
            "id" => "link-to-product-page",
            "default" => "Yes",
            "label" => "Link enlarged image to the product page",
            "type" => "array",
            
            "subType" => "select",
            "values" => array("Yes","No",),
            
        ),
    
);
			$this->params->appendArray($params);
		}
	}

}
?>
