<?php
/**
 * Common Template - tpl_header.php
 *
 * this file can be copied to /templates/your_template_dir/pagename<br />
 * example: to override the privacy page<br />
 * make a directory /templates/my_template/privacy<br />
 * copy /templates/templates_defaults/common/tpl_footer.php to /templates/my_template/privacy/tpl_header.php<br />
 * to override the global settings and turn off the footer un-comment the following line:<br />
 * <br />
 * $flag_disable_header = true;<br />
 *
 * @package templateSystem
 * @copyright Copyright 2003-2006 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: tpl_header.php 4813 2006-10-23 02:13:53Z drbyte $
 */
?>

<?php
  // Display all header alerts via messageStack:
  if ($messageStack->size('header') > 0) {
    echo $messageStack->output('header');
  }
  if (isset($_GET['error_message']) && zen_not_null($_GET['error_message'])) {
  echo htmlspecialchars(urldecode($_GET['error_message']));
  }
  if (isset($_GET['info_message']) && zen_not_null($_GET['info_message'])) {
   echo htmlspecialchars($_GET['info_message']);
} else {

}
?>


<!--bof-header logo and navigation display-->
<?php
if (!isset($flag_disable_header) || !$flag_disable_header) {
?>

<div id="headerWrapper">
<!--bof-branding display-->
<?php echo '<a>' . zen_image($template->get_template_dir("header_bg.gif", DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . "header_bg.gif", HEADER_ALT_TEXT,"100%", HEADER_LOGO_HEIGHT) . '</a>'; ?>

<div style="position: absolute; top: 30px; left: 80px; width: 150px;">
      <?php echo zen_image($template->get_template_dir("title.gif", DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . "title.gif", HEADER_ALT_TEXT, 300, 60); ?>
</div>

<!--
<div id="logoWrapper" >
<div id="navMainSearch"><?php require(DIR_WS_MODULES . 'sideboxes/search_header.php'); ?></div>

<div class="pagetitle"><?php echo HEADER_PAGE_TITLE ?></div>
<div class="paymentway"><?php echo HEADER_PAYMENT_WAY ?></div>
<div class="date"><?php echo strftime(DATE_FORMAT_LONG);?></div>

    <div id="logo" class="logoWrapper">
	<?php echo '<a href="' . HTTP_SERVER . DIR_WS_CATALOG . '">' . zen_image($template->get_template_dir(HEADER_LOGO_IMAGE, DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . HEADER_LOGO_IMAGE, HEADER_ALT_TEXT, 150, HEADER_LOGO_HEIGHT) . '</a>'; ?>
    
	<?php echo '<a href="' . HTTP_SERVER . DIR_WS_CATALOG . '">' . zen_image($template->get_template_dir("title.gif", DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . "title.gif", HEADER_ALT_TEXT, 400, 80) . '</a>'; ?>
    
	
	<?php echo '<a href="' . HTTP_SERVER . DIR_WS_CATALOG . '">' . zen_image($template->get_template_dir("camp_ban_souryou.gif", DIR_WS_TEMPLATE, $current_page_base,'images'). '/' . "camp_ban_souryou.gif", HEADER_ALT_TEXT, 400, 30) . '</a>'; ?>
    
    </div>

<?php if (HEADER_SALES_TEXT != '' || (SHOW_BANNERS_GROUP_SET2 != '' && $banner = zen_banner_exists('dynamic', SHOW_BANNERS_GROUP_SET2))) { ?>
    <div id="taglineWrapper">
<?php
              if (HEADER_SALES_TEXT != '') {
?>
      <div id="tagline"><?php echo HEADER_SALES_TEXT;?></div>
<?php
              }
?>
<?php
              if (SHOW_BANNERS_GROUP_SET2 != '' && $banner = zen_banner_exists('dynamic', SHOW_BANNERS_GROUP_SET2)) {
                if ($banner->RecordCount() > 0) {
?>
      <div id="bannerTwo" class="banners"><?php echo zen_display_banner('static', $banner);?></div>
<?php
                }
              }
?>

    </div>
<?php } // no HEADER_SALES_TEXT or SHOW_BANNERS_GROUP_SET2 ?>
</div>
-->

<!--<br class="clearBoth" />-->
<!--eof-branding display-->

<!--bof-navigation display-->
<div id="navMainWrapper">
<div id="navMain">
<ul class="forward"">
    <li><?php echo '<a href="' . HTTP_SERVER . DIR_WS_CATALOG . '">'; ?><?php echo HEADER_TITLE_CATALOG; ?></a></li>

   <!-- マイページ -->
    <li><a href="<?php echo zen_href_link(FILENAME_ACCOUNT, '', 'SSL'); ?>"><?php echo HEADER_TITLE_MY_ACCOUNT; ?></a></li>
 
    <!-- カートを見る -->
	<?php if ($_SESSION['cart']->count_contents() != 0) { ?>  
    <li><a href="<?php echo zen_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'); ?>"><?php echo HEADER_TITLE_CHECKOUT; ?></a></li>
<?php }?>
    <li class="viewCart"><a href="<?php echo zen_href_link(FILENAME_SHOPPING_CART, '', 'NONSSL'); ?>"><?php echo HEADER_TITLE_CART_CONTENTS; ?></a></li>
  <!-- ログイン/ログアウト -->
	<?php if ($_SESSION['customer_id']) { ?>
	    <li><a href="<?php echo zen_href_link(FILENAME_LOGOFF, '', 'SSL'); ?>"><?php echo HEADER_TITLE_LOGOFF; ?></a></li>
	<?php
		  } else {
	        if (STORE_STATUS == '0') {
	?>
	    	<!-- <li><a href="<?php echo zen_href_link(FILENAME_LOGIN, '', 'SSL'); ?>"><?php echo HEADER_TITLE_LOGIN; ?></a></li> -->
	<?php } } ?>
    <!-- 通販法表記 -->
    <li class="contact"><a href="<?php echo zen_href_link(FILENAME_CONDITIONS, '', 'NONSSL'); ?>"><?php echo BOX_INFORMATION_CONDITIONS; ?></a></li>
      <!-- お問い合わせ -->
    <li class="contact"><a href="<?php echo zen_href_link(FILENAME_CONTACT_US, '', 'SSL'); ?>"><?php echo BOX_INFORMATION_CONTACT; ?></a></li>
  
</ul>

<!--
<ul class="forward">
	
<?php if ($_SESSION['cart']->count_contents() != 0) { ?>
 
    <li><a href="<?php echo zen_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'); ?>"><?php echo HEADER_TITLE_CHECKOUT; ?></a></li>
<?php }?>
    <li class="viewCart"><a href="<?php echo zen_href_link(FILENAME_SHOPPING_CART, '', 'NONSSL'); ?>"><?php echo HEADER_TITLE_CART_CONTENTS; ?></a></li>


<?php if ($_SESSION['customer_id']) { ?>
    <li><a href="<?php echo zen_href_link(FILENAME_LOGOFF, '', 'SSL'); ?>"><?php echo HEADER_TITLE_LOGOFF; ?></a></li>
<?php
	  } else {
        if (STORE_STATUS == '0') {
?>
    	<!-- <li><a href="<?php echo zen_href_link(FILENAME_LOGIN, '', 'SSL'); ?>"><?php echo HEADER_TITLE_LOGIN; ?></a></li>
<?php } } ?>
</ul>
-->

</div>
<!--<div id="navMainSearch"><?php // require(DIR_WS_MODULES . 'sideboxes/search_header.php'); ?></div>-->
<br class="clearBoth" />
</div>
<!--eof-navigation display-->


<!--eof-header logo and navigation display-->

<!--bof-optional categories tabs navigation display-->
<?php require($template->get_template_dir('tpl_modules_categories_tabs.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_categories_tabs.php'); ?>
<!--eof-optional categories tabs navigation display-->

<!--bof-header ezpage links-->
<?php if (EZPAGES_STATUS_HEADER == '1' or (EZPAGES_STATUS_HEADER == '2' and (strstr(EXCLUDE_ADMIN_IP_FOR_MAINTENANCE, $_SERVER['REMOTE_ADDR'])))) { ?>
<?php require($template->get_template_dir('tpl_ezpages_bar_header.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_ezpages_bar_header.php'); ?>
<?php } ?>
<!--eof-header ezpage links-->
</div>
<?php } ?>